TITLE   'Coil and Magnetic Ellipsoid' 				  { ex144.pde }
SELECT   errlim=1e-4	spectral_colors
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   A_phi
DEFINITIONS
   r0=0.2   r00=0.1   z0=0.1   r1=0.2  z1=0.1   r2=0.4   L=1.0
   mu0=4*pi*1e-7   mu   J_phi
   Br=-dz(A_phi)   Bz=1/r*dr(r*A_phi)
   B=vector( Br, Bz)   Bm=magnitude( B)
   Hr=Br/mu   Hz=Bz/mu   H=B/mu   Hm=Bm/mu
   F_coil=vol_integral( -J_phi*Br,'coil')
   fs=0.5*(mu-mu0)*[ tangential(H)^2+ mu/mu0*normal(H)^2]
   unit_z=vector(0,1)				{ Unit vector field along z }
   f=fs*normal( unit_z)				{ z-component }
   F_ellipsoid=surf_integral(  f,'ellipse')
EQUATIONS
   dz( Hr)- dr( Hz)=J_phi
BOUNDARIES
region 'domain'   mu=mu0   J_phi=0				
   start(0,-L) value(A_phi)=0 line to (2*L,-L) to (2*L,L)  to (0,L) to finish
region 'coil'  mu=mu0   J_phi=1e4		{ Current density }		
   start(r1,-z1) line to (r2,-z1) to (r2,z1) to (r1,z1) to finish
region 'ellipsoid'   mu=1000*mu0   J_phi=0   start 'ellipse' (0,z0)
   arc( center=0,z0+r0) to (r00,z0+r0) to (0,z0+2*r0) line to finish
PLOTS
   contour( Bm) painted zoom(0,-2*r2,  4*r2,4*r2)
   vector( B) norm zoom(0,-2*r2,  4*r2,4*r2)
      report(F_coil)   report(F_ellipsoid)
END	
